<?php defined('BASEPATH') OR exit('No direct script access allowed');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing as drawing;
use PhpOffice\PhpSpreadsheet\Style\Alignment as alignment; // Instead alignment
use PhpOffice\PhpSpreadsheet\Style\Fill as fill; // Instead PHPExcel_Style_Fill
use PhpOffice\PhpSpreadsheet\Style\Border as border;
use PhpOffice\PhpSpreadsheet\Style\Color as color_; //Instead PHPExcel_Style_Color
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup as pagesetup; // Instead PHPExcel_Worksheet_PageSetup
use PhpOffice\PhpSpreadsheet\IOFactory as io_factory; // Instead PHPExcel_IOFactory
use PhpOffice\PhpSpreadsheet\Style\Font; //Instead PHPExcel_Style_Color
use Dompdf\Dompdf;
class Timesheet extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->library('ion_auth');
		$this->load->helper('url');
		$this->load->helper('timesheet_helper');
		$this->load->helper('actual_helper');
		$this->load->model('timesheet_model');
		$this->load->model('fee_earner_model');
		$this->load->model('general_model');
		$this->load->model('matter_model');

		
		$this->load->database();

	}

	function index()
	{
		if (!$this->ion_auth->logged_in())
		{
			//redirect them to the login page
			redirect('auth/login', 'refresh');
		}
		else
		{
			//set the flash data error message if there is one
			$this->data['message'] = $this->session->flashdata('message');
			
			$earner_id=($this->session->userdata('group_id')==2)?$this->session->userdata('fee_earner_id'):'';
			
			
			//Paging
			$config = array();
			$config['base_url'] = base_url() . 'timesheet/index/';
			$config['total_rows'] = $this->timesheet_model->record_count($earner_id);
			$config['per_page'] = 15;
			$config['uri_segment'] = 3;
 
			$this->pagination->initialize($config);
			
			$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
			$data['timesheets'] = $this->timesheet_model->fetch_timesheet($config['per_page'], $page,$earner_id);
			$data['links'] = $this->pagination->create_links();
			
			
			$data['dt_timesheet'] = array(
				'name'  => 'dt_timesheet',
				'id'    => 'dt_timesheet',
				'type'  => 'text',
				'class' => 'input-small validate[required] datepicker',
				'value' => date('Y-m-d'),
			);
			
			$data['description'] = array(
				'name'  => 'description',
				'id'    => 'description',
				'type'  => 'text',
				'class' => 'input-xlarge validate[required]',
				'placeholder'=>'DESCRIPTION',
				'rows'	=> 3,
				'value' => $this->form_validation->set_value('description'),
			);
			
			$data['actual_unit'] = array(
				'name'  => 'actual_unit',
				'id'    => 'actual_unit',
				'type'  => 'text',
				'class' => 'input-medium validate[required]',
				'placeholder'=>'UNIT',
				'value' => $this->form_validation->set_value('actual_unit'),
			);
			
			$data['actual_length'] = array(
				'name'  => 'actual_length',
				'id'    => 'actual_length',
				'type'  => 'text',
				'class' => 'input-medium validate[required]',
				'placeholder'=>'LEN',
				'value' => '00:00',
			);
			
			//get all matters
			
			//print_r($matters);exit();
			$array_matters=array();
			//$array_matters['']='--All--';
			if($this->session->userdata('group_id')==1){
				
			}else{
				$matters=$this->timesheet_model->get_all_matters($earner_id);
				foreach($matters as $row)
				{
					$array_matters[$row['id']]=$row['matter'].', '.$row['clientname'];
				}
			}
			
			//print_r($array_matters);exit();
			$data['matters'] =$array_matters;
			
			//get all fee clients
			$clients=$this->general_model->get_all_clients();
			$array_clients=array();
			$array_clients['']='--All--';
			foreach($clients as $row)
			{
				$array_clients[$row['id']]=$row['clientname'];
			}
			$data['clients'] =$array_clients;			

			if($this->session->userdata('group_id')==1){
				//get all fee earners
				$earners=$this->general_model->get_all_earners();
				$array_earners=array();
				$array_earners['']='--All--';
				foreach($earners as $row)
				{
					$array_earners[$row['id']]=$row['first_name'].' '.$row['last_name'];
				}
				
			
				$data['earners'] =$array_earners;
				
				
				$data['billables'] =array(
					''=>'--All--',
					'1'=>'Billable',
					'0'=>'Unbillable',
				);
				
			}
			
			//for paging
			$data['baseurl'] =$config['base_url'];
			$data['page'] =$page;
			
			$pages=array();
			$number_page=0;
			for($i=0;$i<ceil($config['total_rows']/$config['per_page']);$i++)
			{
				$pages[$number_page]=$i+1;
				$number_page+=$config['per_page'];
			}
			$data['pages'] =$pages;
			//===========================================================
			$this->load->view('timesheet/index', $data);
		}
	}

	function search()
	{

		if (!$this->ion_auth->logged_in())
		{
			//redirect them to the login page
			redirect('auth/login', 'refresh');
		}
		else
		{
			//set the flash data error message if there is one
			$this->data['message'] = $this->session->flashdata('message');
			
			$earner_id=($this->session->userdata('group_id')==2)?$this->session->userdata('fee_earner_id'):'';
			
			//get data 
			$matter_id=isset($_POST['matter_id'])?($_POST['matter_id']==0?"":$this->input->post('matter_id')):$this->session->userdata('matter_id');
			$fee_earner_id=isset($_POST['fee_earner_id'])?$this->input->post('fee_earner_id'):$this->session->userdata('fee_earner_id');
			$client_id=isset($_POST['client_id'])?$this->input->post('client_id'):$this->session->userdata('client_id');
			$billable=isset($_POST['billable'])?$this->input->post('billable'):$this->session->userdata('billable');
			$from=isset($_POST['from'])?$this->input->post('from'):$this->session->userdata('from');
			$to=isset($_POST['to'])?$this->input->post('to'):$this->session->userdata('to');
			
			
			
			$data['matter_id'] = $matter_id;
			$data['fee_earner_id'] = $fee_earner_id;
			$data['client_id'] = $client_id;
			$data['billable'] = $billable;
			$data['from'] = $from;
			$data['to'] = $to;
			
			//masukkan session untuk paging
			$session_data=array(
				'matter_id'=>$matter_id,
				'fee_earner_id'=>$fee_earner_id,
				'client_id'=>$client_id,
				'billable'=>$billable,
				'from'=>$from,
				'to'=>$to,
			);
			
			$this->session->set_userdata($session_data);
			
			
			
			//Paging
			$config = array();
			$config['base_url'] = base_url() . 'timesheet/search/';
			$config['total_rows'] = $this->timesheet_model->record_count($earner_id,$session_data);
			$config['per_page'] = 15;
			$config['uri_segment'] = 3;
 
			$this->pagination->initialize($config);
			
			$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
			$data['timesheets'] = $this->timesheet_model->fetch_timesheet($config['per_page'], $page,$earner_id,$session_data);
			$data['links'] = $this->pagination->create_links();
			
			
			$data['dt_timesheet'] = array(
				'name'  => 'dt_timesheet',
				'id'    => 'dt_timesheet',
				'type'  => 'text',
				'class' => 'input-small validate[required] datepicker',
				'value' => date('Y-m-d'),
			);
			
			$data['description'] = array(
				'name'  => 'description',
				'id'    => 'description',
				'type'  => 'text', 
				'class' => 'input-xlarge validate[required]',
				'rows' => '5',
				'placeholder'=>'DESCRIPTION',
				'value' => $this->form_validation->set_value('description'),
			);
			
			$data['actual_unit'] = array(
				'name'  => 'actual_unit',
				'id'    => 'actual_unit',
				'type'  => 'text',
				'class' => 'input-medium validate[required]',
				'placeholder'=>'UNIT',
				'value' => $this->form_validation->set_value('actual_unit'),
			);
			
			$data['actual_length'] = array(
				'name'  => 'actual_length',
				'id'    => 'actual_length',
				'type'  => 'text',
				'class' => 'input-medium validate[required]',
				'placeholder'=>'LEN',
				'value' => $this->form_validation->set_value('actual_length'),
			);
			
			//get all matters
			$array_matters=array();
			$array_matters['']='--All--';
			
			if($this->session->userdata('group_id')==1){
				if($client_id!=''){
					$matters=$this->matter_model->getmatterbyclient($client_id);
					foreach($matters as $key => $value)
					{
						$array_matters[$key]=$value;
					}
				}
			}else{
				$matters=$this->timesheet_model->get_all_matters($earner_id);
				foreach($matters as $row)
				{
					$array_matters[$row['id']]=$row['matter'].', '.$row['clientname'];
				}
			}
			
			$data['matters'] =$array_matters;
			
			if($this->session->userdata('group_id')==1){
				//get all fee earners
				$earners=$this->general_model->get_all_earners();
				$array_earners=array();
				$array_earners['']='--All--';
				foreach($earners as $row)
				{
					$array_earners[$row['id']]=$row['first_name'].' '.$row['last_name'];
				}
				
			
				$data['earners'] =$array_earners;
				
				//get all fee clients
				$clients=$this->general_model->get_all_clients();
				$array_clients=array();
				$array_clients['']='--All--';
				foreach($clients as $row)
				{
					$array_clients[$row['id']]=$row['clientname'];
				}
				
			
				$data['clients'] =$array_clients;
				
				$data['billables'] =array(
					''=>'--All--',
					'1'=>'Billable',
					'0'=>'Unbillable',
				);
			}
			
			//for paging
			$data['baseurl'] =$config['base_url'];
			$data['page'] =$page;
			$number_page=0;
			$pages=array();
			for($i=0;$i<ceil($config['total_rows']/$config['per_page']);$i++)
			{
				$pages[$number_page]=$i+1;
				$number_page+=$config['per_page'];
			}
			$data['pages'] =$pages;
			//===========================================================
			
			
			//for sign in report
			$data['search'] =1;
			
			$this->load->view('timesheet/index', $data);
			
		}
	}	
	
	function show()
	{

		if (!$this->ion_auth->logged_in())
		{
			//redirect them to the login page
			redirect('auth/login', 'refresh');
		}
		else
		{
			//set the flash data error message if there is one
			$this->data['message'] = $this->session->flashdata('message');
			
			//masukkan session untuk paging
			if ($_POST){
				$session_data=array(
					'matter_id'=>$this->input->post('matter_id'),
					'from'=>$this->input->post('from'),
					'to'=>$this->input->post('to'),
				);
				
				$this->session->set_userdata($session_data);
			}else{
				$session_data=array(
					'matter_id'=>$this->session->userdata('matter_id'),
					'from'=>$this->session->userdata('from'),
					'to'=>$this->session->userdata('to'),
				);
			}
			$session_data['fee_earner_id']=$this->session->userdata('fee_earner_id');
			$session_data['client_id']='';
			
			//get data 
			$matter_id=$this->session->userdata('matter_id')!=''?$this->session->userdata('matter_id'):'';
			$fee_earner_id=$this->session->userdata('fee_earner_id');
			$from=$this->session->userdata('from')!=''?$this->session->userdata('from'):'';
			$to=$this->session->userdata('to')!=''?$this->session->userdata('to'):'';
			
			
			
			$data['matter_id'] = $matter_id;
			$data['from'] = $from;
			$data['to'] = $to;
			
			//Paging
			$config = array();
			$config['base_url'] = base_url() . 'timesheet/search/';
			$config['total_rows'] = $this->timesheet_model->record_count($fee_earner_id,$session_data);
			$config['per_page'] = 15;
			$config['uri_segment'] = 3;
 
			$this->pagination->initialize($config);
			
			$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
			$data['timesheets'] = $this->timesheet_model->fetch_timesheet($config['per_page'], $page,$fee_earner_id,$session_data);
			$data['links'] = $this->pagination->create_links();
			
			//get all matters
			$matters=$this->timesheet_model->get_all_matters($fee_earner_id);
			$array_matters=array();
			$array_matters['']='--All--';
			foreach($matters as $row)
			{
				$array_matters[$row['id']]=$row['matter'];
			}
			$data['matters'] =$array_matters;
			
			//for paging
			$data['baseurl'] =$config['base_url'];
			$data['page'] =$page;
			$number_page=0;
			$pages=array();
			for($i=0;$i<ceil($config['total_rows']/$config['per_page']);$i++)
			{
				$pages[$number_page]=$i+1;
				$number_page+=$config['per_page'];
			}
			$data['pages'] =$pages;
			//===========================================================
			
			//for sign in report
			$data['search'] =1;
			$data['fee_earner'] = $this->fee_earner_model->detail($fee_earner_id);
			//print_r($data['fee_earner']);exit();
			
			$this->load->view('timesheet/show', $data);
			
		}
	}	

	function create()
	{
		
		if (!$this->ion_auth->logged_in())
		{
			redirect('auth/login', 'refresh');
		}

		//validate form input
		$this->form_validation->set_rules('dt_timesheet', 'Date Timesheet', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('matter_id', 'Matter', 'required');
		//$this->form_validation->set_rules('actual_unit', 'Actual Unit', 'required');
		$this->form_validation->set_rules('actual_length', 'Actual Length', 'required');
		if($this->session->userdata('group_id')==1){
			$this->form_validation->set_rules('fee_earner_id', 'Associate', 'required');
		}
		
		
		if ($this->form_validation->run() == true)
		{
			//get detail matter
			$matter_detail=$this->timesheet_model->getMatterDetail($this->input->post('matter_id'));
			$billable=($matter_detail['client_id']==114)?0:1;
			$fee_earner_id = $this->session->userdata('group_id')==1?$this->input->post('fee_earner_id'):$this->session->userdata('fee_earner_id');
			$data=array(
				'dt_timesheet' => $this->input->post('dt_timesheet'),
				'description'  => $this->input->post('description'),
				'matter_id'  => $this->input->post('matter_id'),
				'fee_earner_id'  => $fee_earner_id,
				'actual_length'  => $this->input->post('actual_length'),
				'actual_unit'  => $this->length2unit($this->input->post('actual_length')),
				'length'  => $this->input->post('actual_length'),
				'unit'  => $this->length2unit($this->input->post('actual_length')),
				'billable'  => $billable,
			);
			if($this->timesheet_model->create($data))
			{
				$this->session->set_flashdata('message', 'Timesheet has been saved');
			}else{
				$this->session->set_flashdata('message', 'Timesheet cannot be saved. Please try again');
			}
			
		}		
		else
		{
			$this->session->set_flashdata('message', validation_errors());
		}
		
		redirect('timesheet', 'refresh');
	}

	
	function delete(){
		
		if (!$this->ion_auth->logged_in())
		{
			redirect('auth/login', 'refresh');
		}
        $id=$this->input->post('timesheet_id');
		
		if($this->timesheet_model->delete( $id )){
			$this->session->set_flashdata('message', 'Timesheet Deleted');		
			$result=array(
				'status'=>1,
				'message'=>'succes'
			);
		}else{
			$result=array(
				'status'=>0,
				'message'=>'Timesheet Could be deleted. Please try again'
			);
		}		
		
		echo json_encode($result);
	}
	
	function edit_data(){		
		$data=array(
			'id' => $this->input->post('id'),
			'dt_timesheet' => $this->input->post('dt_timesheet'),
			'description'  => $this->input->post('description'),
			'matter_id'  => $this->input->post('matter_id'),
			'actual_unit'  => $this->input->post('actual_unit'),
			'actual_length'  => $this->input->post('actual_length'),
			'billable'  => $this->input->post('billable'),
		);
		
		if($this->timesheet_model->edit($data))
		{
			$this->session->set_flashdata('message', 'Timesheet has been saved');
			$result=array(
				'status'=>1,
				'message'=>'succes'
			);
		}else{
			$result=array(
				'status'=>0,
				'message'=>'Timesheet cannot be saved. Please try again'
			);
		
		}		
		echo json_encode($result);
	}
	
	public function exportxls($search='') {
		if (!$this->ion_auth->logged_in())
		{
			redirect('timesheet/index', 'refresh');
		}
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();


		$styleThinBlackBorderOutline = array(
			'borders' => array(
				'outline' => array(
					'borderStyle' => border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				),
			),
		);

		$allborder = array(
			'borders' => array(
				'allBorders' => array(
					'borderStyle' => border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				),
			),
		);
		

		$sheet->mergeCells('A1:G1');
		$sheet->setCellValue('A1', 'REPORT TIMESHEET');
		$sheet->getStyle('A1')->getFont()->setSize(20);
		$sheet->getStyle('A1')->getFont()->setBold(true);
		$sheet->getStyle('A1:G1')->getFill()->setFillType(fill::FILL_SOLID);
		$sheet->getStyle('A1:G1')->applyFromArray($styleThinBlackBorderOutline);
		 $style = array(
	        'alignment' => array(
	            'horizontal' => alignment::HORIZONTAL_CENTER,
	        )
	    );


   		$sheet->getStyle("A1:G1")->applyFromArray($style);
		//$sheet->getStyle('A1:G1')->getAlignment()->setHorizontal(alignment::HORIZONTAL_JUSTIFY);
		$sheet->getColumnDimension('A')->setWidth(20);
		$sheet->setCellValue('A2', 'INIT')
                              ->setCellValue('B2', 'DATE')
                              ->setCellValue('C2', 'HOURS')
                              ->setCellValue('D2', 'DESCRIPTION')
                              ->setCellValue('E2', 'RATE')
                              ->setCellValue('F2', 'FEES')
                              ->setCellValue('G2', 'CUMULATIVE')
                              ;
        $sheet->getStyle('A2:G2')->applyFromArray($allborder);
		
		
		
		//get data
		$matter_id=isset($_REQUEST['matter_id'])?$_REQUEST['matter_id']:'';
		$fee_earner_id=isset($_REQUEST['fee_earner_id'])?$_REQUEST['fee_earner_id']:(($this->session->userdata('group_id')==2)?$this->session->userdata('fee_earner_id'):'');
		$client_id=isset($_REQUEST['client_id'])?$_REQUEST['client_id']:'';
		$billable=isset($_REQUEST['billable'])?$_REQUEST['billable']:'';
		$from=isset($_REQUEST['from'])?$_REQUEST['from']:'';
		$to=isset($_REQUEST['to'])?$_REQUEST['to']:'';
				
		$session_data=array(
			'matter_id'=>$matter_id,
			'fee_earner_id'=>$fee_earner_id,
			'client_id'=>$client_id,
			'billable'=>$billable,
			'from'=>$from,
			'to'=>$to,
		);
		$result=$this->timesheet_model->getAllTimesheetNew($session_data,'asc');	
		
		
		//print_r($result);exit();
		
		$row=3;
		
		foreach($result as $id_client=>$client_matters){
			$total=0;
			$total_rate=0;
			$curr='';
			$id=0;
			foreach($client_matters as $key=>$val){
				$client_name=$val[0]['clientname'];
				$client_code=$val[0]['clientcode'];
				$matter=$val[0]['matter'];
				if($id==0){
					$sheet->setCellValue('A'.$row, '#CLIENT');
					$sheet->mergeCells('B'.$row.':C'.$row);
					$sheet->setCellValue('B'.$row, $client_code);
					$sheet->setCellValue('D'.$row, $client_name);
				}
				$row++;
				$sheet->mergeCells('A'.$row.':C'.$row);
				$sheet->setCellValue('A'.$row, '#MATTER');
				$sheet->setCellValue('D'.$row, $matter);
		
				$sub_total_rate=0;
				$sub_total=0;
				foreach($val as $timesheet){
					$row++;
					$rate=$this->timesheet_model->getRateFeeEarnerMatter($timesheet['matter_id'],$timesheet['fee_earner_id']);				
					$rate_per_hour=$rate['rate_per_hour']>0?$rate['rate_per_hour']:'0';
					$amount=$timesheet['unit']*$rate_per_hour;
					$sub_total+=$amount;
					$sub_total_rate+=$timesheet['unit'];
					$amount_text=number_format($amount,2);
					$total_text=number_format($sub_total,2);
					$curr=$rate['currency'];
					
					$dataArray = array(	
						$timesheet['fee_earner_code'],
						date('d/m/Y',strtotime($timesheet['dt_timesheet'])),
						$timesheet['unit'],
						ucfirst($timesheet['description']),
						$rate_per_hour,
						$amount,
						$sub_total,
					);
					$sheet->fromArray($dataArray, NULL, 'A'.$row);		
				}
				$total_rate+=$sub_total_rate;	
				$total+=$sub_total;	
				
				$row++;
				$sheet->mergeCells('A'.$row.':B'.$row);
				$sheet->setCellValue('A'.$row, '#TOTAL MATTER');
				$sheet->setCellValue('C'.$row, $sub_total_rate);
					
				
				$id++;
			}
		
			$total_text=number_format($total,2);
			
			$row++;
			$sheet->mergeCells('A'.$row.':B'.$row);
			$sheet->setCellValue('A'.$row, 'TOTAL CLIENT');
			$sheet->mergeCells('C'.$row.':F'.$row);
			$sheet->setCellValue('F'.$row, $total_rate);
			$sheet->setCellValue('G'.$row, $total);
			$row++;
		}
		
		
		
		$sheet->getStyle('A3:G'.$row)->applyFromArray($allborder);
		
		//set styling
		$sheet->getColumnDimension('A')->setAutoSize(true);
		$sheet->getColumnDimension('B')->setAutoSize(true);
		$sheet->getColumnDimension('C')->setAutoSize(true);
		$sheet->getColumnDimension('D')->setWidth(30);
		$sheet->getColumnDimension('E')->setAutoSize(true);
		$sheet->getColumnDimension('F')->setAutoSize(true);
		$sheet->getColumnDimension('G')->setAutoSize(true);
		$sheet->getStyle('A1:G1')->getFont()->setBold(true);
		
		$align = array(
	        'alignment' => array(
	            'horizontal' => alignment::HORIZONTAL_RIGHT,
	        ),
	    );
		
		$sheet->getStyle("E1:G".($row+2))->applyFromArray($align);
		
		//align wrap
		$styleArray = array(
			'alignment' => array(
				'wrap'       => true,
				//'horizontal' => alignment::HORIZONTAL_CENTER,
				'vertical' => alignment::VERTICAL_CENTER
            ),
		);
		$sheet->getStyle("A2:G".($row+2))->applyFromArray($styleArray);
		
		$sheet->getStyle('E5:G'.($row+2))->getNumberFormat()->setFormatCode("#,##0.00");
	
		$filename='timesheet-'.time().'.xlsx';
		// Proses file excel
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
		header('Cache-Control: max-age=0');
		$writer = new Xlsx($spreadsheet);
		$writer->save('php://output');

	}

	public function exportnewxls($search='') {
		if (!$this->ion_auth->logged_in())
		{
			redirect('timesheet/index', 'refresh');
		}
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();

		$sheet->mergeCells('A1:N1');
		$sheet->setCellValue('A1', 'REPORT TIMESHEET');
		$sheet->getStyle('A1')->getFont()->setSize(20);
		$sheet->getStyle('A1')->getFont()->setBold(true);
		$sheet->getStyle('A1:N1')->getFill()->setFillType(fill::FILL_SOLID);
		$sheet->getColumnDimension('A')->setWidth(20);

		$allborder = array(
			'borders' => array(
				'allBorders' => array(
					'borderStyle' => border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				),
			),
		);
		
		 $style = array(
	        'alignment' => array(
	            'horizontal' => alignment::HORIZONTAL_CENTER,
	        ),
			'borders' => array(
				'outline' => array(
					'borderStyle' => border::BORDER_THIN,
				),
			),
	    );


   		$sheet->getStyle("A1:N1")->applyFromArray($style);
   		
		
		//get data 
		$client_id=isset($_POST['client_id'])?$_POST['client_id']:'';
		$this->load->model('client_model');
		
		if($client_id!=''){
			$clientdata = $this->client_model->detail($client_id);
			$sheet->mergeCells('A2:B2');
			$sheet->setCellValue('A2', 'Client');
			$sheet->mergeCells('C2:D2');
			$sheet->setCellValue('C2', $clientdata->clientname);
		}else{
			$sheet->mergeCells('A2:B2');
			$sheet->setCellValue('A2', 'Client');
			$sheet->mergeCells('C2:D2');
			$sheet->setCellValue('C2', 'All');
		}
		
		$matter_id=isset($_POST['matter_id'])?$_POST['matter_id']:'';
		if($matter_id>0){
			$matterdata = $this->timesheet_model->getMatterDetail($matter_id);
			$sheet->mergeCells('A3:B3');
			$sheet->setCellValue('A3', 'Matter');
			$sheet->mergeCells('C3:D3');
			$sheet->setCellValue('C3', $matterdata['matter']);
		}else{
			$sheet->mergeCells('A3:B3');
			$sheet->setCellValue('A3', 'Matter');
			$sheet->mergeCells('C3:D3');
			$sheet->setCellValue('C3', 'All');
		}
		
		$fee_earner_id=isset($_POST['fee_earner_id'])?$_POST['fee_earner_id']:'';		
		if($fee_earner_id>0){
			$fee_earner_data = $this->timesheet_model->getFeeEarnerDetail($fee_earner_id);
			$sheet->mergeCells('A4:B4');
			$sheet->setCellValue('A4', 'Associate');
			$sheet->mergeCells('C4:N4');
			$sheet->setCellValue('C4', $fee_earner_data['first_name'].' '.$fee_earner_data['last_name']);
		}else{
			$sheet->mergeCells('A4:B4');
			$sheet->setCellValue('A4', 'Associate');
			$sheet->mergeCells('C4:N4');
			$sheet->setCellValue('C4','All');
		}
		
		$billable=isset($_POST['billable'])?$_POST['billable']:'';		
		
		$from=isset($_POST['from'])?$_POST['from']:'';
		$to=isset($_POST['to'])?$_POST['to']:'';		
		
		if($from!='' && $to!=''){
			$sheet->setCellValue('E2', 'Period');
			$sheet->mergeCells('F2:H2');
			$sheet->setCellValue('F2', date('d/m/Y',strtotime($from)).' - '.date('d/m/Y',strtotime($to)));
		}else{
			$sheet->setCellValue('E2', 'Period');
			$sheet->mergeCells('F2:H2');
			$sheet->setCellValue('F2', 'All');
		}
		
		$session_data=array(
			'matter_id'=>$matter_id,
			'fee_earner_id'=>$fee_earner_id,
			'client_id'=>$client_id,
			'billable'=>$billable,
			'from'=>$from,
			'to'=>$to,
		);
		

		$result=$this->timesheet_model->getAllTimesheetNew($session_data,'asc');
		
		$sheet->setCellValue('E3', 'Status');
		$sheet->mergeCells('F3:H3');
		$sheet->setCellValue('F3', 'Billed | Unbilled | Non Billable |');
		
		//$sheet->mergeCells('G3:K3');
		$sheet->setCellValue('A6', 'NO')
                              ->setCellValue('B6', 'Billable')
                              ->setCellValue('C6', 'Date')
                              ->setCellValue('D6', 'Associate')
                              ->setCellValue('E6', 'Work code')
                              ->setCellValue('F6', 'Description')
                              ->setCellValue('G6', 'Matter')
                              ->setCellValue('H6', 'Client')
                              ->setCellValue('I6', 'Unit')
                              ->setCellValue('J6', 'Length')
                              ->setCellValue('K6', 'Actual Unit')
                              ->setCellValue('L6', 'Actual Length')
                              ->setCellValue('M6', 'Rate per Hour') 
                              ->setCellValue('N6', 'Amount') 
                              ;
		
		
		$sheet->getStyle('A6:N6')->applyFromArray($allborder);
		$sheet->getStyle('A6:N6')->getFont()->setBold(true);
		$sheet->setAutoFilter('A6:N6');
		
		
		$row=7;
		$i=1;
		
		$total=0;
		$total_actual_unit=0;
		$total_length_unit=0;
		$total_rate=0;
		$currency='';
		foreach($result as $id_client=>$client_matters){
			foreach($client_matters as $key=>$val){
				foreach($val as $timesheet){
					$billable=$timesheet['billable']?'Yes':'No';
					$rate=$this->timesheet_model->getRateFeeEarnerMatter($timesheet['matter_id'],$timesheet['fee_earner_id']);
					
					$rate_per_hour=$rate['rate_per_hour']>0?$rate['rate_per_hour']:'0';
					
					$amount=$timesheet['unit']*$rate_per_hour;
					
					
					$total+=$amount;
					$total_actual_unit+=$timesheet['actual_unit'];
					$total_length_unit+=$timesheet['unit'];
					$total_rate+=$rate_per_hour;
					
					$amount_text=number_format($amount,2);
					$currency=$rate['currency'];
					
					$dataArray = array(	
						$i,
						$billable,
						date('d/m/Y',strtotime($timesheet['dt_timesheet'])),
						$timesheet['first_name'].' '.$timesheet['last_name'],
						'',
						ucfirst($timesheet['description']),
						$timesheet['matter'],
						$timesheet['clientname'],
						$timesheet['unit'],
						unit2length($timesheet['unit']),
						$timesheet['actual_unit'],
						unit2length($timesheet['actual_unit']),
						$rate_per_hour,
						$amount,
					);
					$sheet->fromArray($dataArray, NULL, 'A'.$row++);
					$sheet->getStyle('A'.($row-1).':N'.($row-1))->applyFromArray($allborder);
					$i++;
				}
			}
		}
		
		$total_text=number_format($total,2);
		
		$sheet->mergeCells('A'.$row.':H'.$row);
		$sheet->setCellValue('A'.$row, 'Total');
		$sheet->setCellValue('I'.$row, $total_actual_unit);
		$sheet->setCellValue('J'.$row, unit2length($total_actual_unit));
		$sheet->setCellValue('K'.$row, $total_length_unit);
		$sheet->setCellValue('L'.$row, unit2length($total_length_unit));
		$sheet->setCellValue('M'.$row, $total_rate);
		$sheet->setCellValue('N'.$row, $total);
		
		$sheet->getStyle('A'.($row).':N'.($row))->applyFromArray($allborder);
		$sheet->getStyle('A'.$row.':N'.$row)->getFont()->setBold(true);
		
		
		
		//$sheet->getStyle('A4:N'.$row)->applyFromArray($allborder);
		$sheet->getColumnDimension('A')->setAutoSize(true);
		$sheet->getColumnDimension('B')->setAutoSize(true);
		$sheet->getColumnDimension('C')->setAutoSize(true);
		$sheet->getColumnDimension('D')->setAutoSize(true);
		$sheet->getColumnDimension('E')->setAutoSize(true);
		$sheet->getColumnDimension('F')->setWidth(30);
		$sheet->getColumnDimension('G')->setAutoSize(true);
		$sheet->getColumnDimension('H')->setAutoSize(true);
		$sheet->getColumnDimension('I')->setAutoSize(true);
		$sheet->getColumnDimension('J')->setAutoSize(true);
		$sheet->getColumnDimension('K')->setAutoSize(true);
		$sheet->getColumnDimension('L')->setAutoSize(true);
		$sheet->getColumnDimension('M')->setAutoSize(true);
		$sheet->getColumnDimension('N')->setAutoSize(true);
		
		//set styling
		$sheet->getStyle('A1:N1')->getFont()->setBold(true);
		
		$align = array(
	        'alignment' => array(
	            'horizontal' => alignment::HORIZONTAL_RIGHT,
	        ),
	    );
		
		$sheet->getStyle("I7:N".$row)->applyFromArray($align);
		
		//align wrap
		$styleArray = array(
			'alignment' => array(
				'wrap'       => true,
				//'horizontal' => alignment::HORIZONTAL_CENTER,
				'vertical' => alignment::VERTICAL_CENTER
            ),
		);
		$sheet->getStyle("A7:N".$row)->applyFromArray($styleArray);
		$sheet->getStyle('M7:N'.($row))->getNumberFormat()->setFormatCode("#,##0.00");
		
		$filename='newtimesheet-'.time().'.xlsx';
		// Proses file excel
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
		header('Cache-Control: max-age=0');
		$writer = new Xlsx($spreadsheet);
		$writer->save('php://output');
	}
	
	public function exportpdf(){
	
		if (!$this->ion_auth->logged_in())
		{
			redirect('timesheet/index', 'refresh');
		}
		
		ini_set('memory_limit', '2048M');
		
		//get data 
		$matter_id=isset($_REQUEST['matter_id'])?$_REQUEST['matter_id']:'';
		$fee_earner_id=isset($_REQUEST['fee_earner_id'])?$_REQUEST['fee_earner_id']:(($this->session->userdata('group_id')==2)?$this->session->userdata('fee_earner_id'):'');
		$client_id=isset($_REQUEST['client_id'])?$_REQUEST['client_id']:'';
		$billable=isset($_REQUEST['billable'])?$_REQUEST['billable']:'';
		$from=isset($_REQUEST['from'])?$_REQUEST['from']:'';
		$to=isset($_REQUEST['to'])?$_REQUEST['to']:'';
		
		$session_data=array(
			'matter_id'=>$matter_id,
			'fee_earner_id'=>$fee_earner_id,
			'client_id'=>$client_id,
			'billable'=>$billable,
			'from'=>$from,
			'to'=>$to,
		);
		$result=$this->timesheet_model->getAllTimesheetNew($session_data,'asc');
		$data['result']=$result;
		$html = $this->load->view('timesheet/report',$data,true);
		
		$dompdf = new Dompdf();
		$dompdf->loadHtml($html);
		$dompdf->render();

		$dompdf->stream("timesheet_".time().".pdf");
	}
	
	public function getDataReport($search=''){
		if($search!=''){
			//get data 
			$matter_id=$this->session->userdata('matter_id');
			$fee_earner_id=$this->session->userdata('fee_earner_id');
			$client_id=$this->session->userdata('client_id');
			$from=$this->session->userdata('from');
			$to=$this->session->userdata('to');
			
			$session_data=array(
				'matter_id'=>$matter_id,
				'fee_earner_id'=>$fee_earner_id,
				'client_id'=>$client_id,
				'from'=>$from,
				'to'=>$to,
			);
			
			$result=$this->timesheet_model->fetch_timesheet('', '','',$session_data);
		}else{
			$result=$this->timesheet_model->fetch_timesheet();
		}
		
		return $result;
	}
	
	public function edit_item(){
		$id=$this->input->post('timesheet_id');
		$show=isset($_POST['show'])?1:0;
		$this->data['show']=$show;
		
		$timesheet = $this->timesheet_model->detail($id);
		$this->data['timesheets'] = $timesheet;
		
		$this->data['dt_timesheet'] = array(
				'name'  => 'dt_timesheet',
				'type'  => 'text',
				'class' => 'input-small validate[required]',
				'value' => $this->form_validation->set_value('dt_timesheet', $timesheet->dt_timesheet),
			);
			
			$this->data['description'] = array(
				'name'  => 'description',
				'type'  => 'text',
				'class' => 'input-xlarge validate[required]',
				'rows' => '5',
				'placeholder'=>'DESCRIPTION',
				'value' => $this->form_validation->set_value('description', ucfirst($timesheet->description)),
			);
			
			$this->data['actual_unit'] = array(
				'name'  => 'actual_unit',
				'type'  => 'text',
				'class' => 'input-medium validate[required]',
				'placeholder'=>'UNIT',
				'value' => $this->form_validation->set_value('actual_unit', $timesheet->actual_unit),
			);
			
			
			$length=$this->session->userdata('group_id')==2?$timesheet->actual_length:$timesheet->length;
			$this->data['actual_length'] = array(
				'name'  => 'actual_length',
				'type'  => 'text',
				'class' => 'input-medium validate[required]',
				'placeholder'=>'LEN',
				'value' => $this->form_validation->set_value('actual_length', $length),
			);
			
			//get all matters
			$matters=$this->timesheet_model->get_all_matters($timesheet->fee_earner_id);
			$array_matters=array();
			foreach($matters as $row)
			{
				$array_matters[$row['id']]=$row['matter'];
			}
			$this->data['matters'] =$array_matters;
			
			$this->load->view('timesheet/edit_text',$this->data);
	}
	
	public function save_edit(){
		$data=array(
				'id' => $this->input->post('timesheet_id'),
				'dt_timesheet' => $this->input->post('tm_date'),
				'description'  => $this->input->post('tm_description'),
		);
		
		if($this->session->userdata('group_id')==2){
			$data['actual_length']=$this->input->post('tm_actual_length');
			$data['actual_unit']=$this->length2unit($this->input->post('tm_actual_length'));
			$data['length'] = $this->input->post('tm_actual_length');
			$data['unit']= $this->length2unit($this->input->post('tm_actual_length'));
		}else{
			$data['length'] = $this->input->post('tm_actual_length');
			$data['unit']= $this->length2unit($this->input->post('tm_actual_length'));
		}
		
		if(isset($_POST['tm_matter_id'])){
			$data['matter_id']=$this->input->post('tm_matter_id');
		}
		$show=isset($_POST['show'])?1:0;
		$this->data['show']=$show;
		
		if($this->session->userdata('group_id')==1){
			$data['billable']=$this->input->post('tm_billable');
		}
		
		$this->timesheet_model->edit($data);
		$timesheet = $this->timesheet_model->detail($data['id']);
		
		$this->data['timesheet'] = $timesheet;
		$this->load->view('timesheet/result_text',$this->data);
	}
	
	function length2unit($length)
	{
		if ((strpos($length, ":") === false)) {
			return $length;
		} else {
			$array_length=explode(":",$length);
			$unit1=(int)$array_length[0];
			$unit2=number_format(((int)$array_length[1])/60,2);
			
			$unit=number_format(($unit1+$unit2),2);	
			return $unit;
		}
	}
	
	function getClient($id_matter=1)
	{
		$matters=$this->timesheet_model->get_detail_matters($id_matter);
		$client_name='-';
		if(!empty($matters)){
			$client_name=$matters->gelar_name.' '.$matters->clientname;
		}
		echo $client_name;
	}

	function getmatterclient($client=''){
		if($client>0){
			$matter = $this->matter_model->getmatterbyclient($client);
			$array_matter[''] = '--All--';
			if(!empty($matter)){
				$array_matter+=$matter;
			}
			foreach ($array_matter as $key => $value) {
				echo '<option value="'.$key.'">'.$value.'</option>';
			}
		 }else{
			echo '<option value="">--All--</option>';
		 }
		 exit();
	}
	
	function getmatterearner($fee_earner_id=0){
		if((int)$fee_earner_id>0){
			$matters=$this->timesheet_model->get_all_matters($fee_earner_id);
			$array_matter[''] = '--Select Matter--';
			foreach($matters as $row)
			{
				echo '<option value="'.$row['id'].'">'.$row['matter'].', '.$row['clientname'].'</option>';
			}
		 }else{
			echo '<option value="">--Select Matter--</option>';
		 }
		 exit();
	}
}


